<?php

require "../../src/config.php";

if (isset($_GET['id'])) {
    $user_id = $_GET['id'];
    $user = users::get($_GET["id"]);
    if (!$user) {
        error("Invalid User Profile");
    }
} else if (auth::user()) {
    $user_id = auth::user();
    $user = users::get($user_id);
} else {
    router::redirect("login");
}


$user = users::get($user_id);
$lastseen = users::lastseen($user_id);

page::set([
    "title" => "Profile",
    "page_id" => "profile_home",
    "nav-parent" => "user_profile_" . $user_id,
    "size" => "box-full",
    "scripts" => ["chartjs"]
]);

require FILE_ROOT . "src/layouts/admin/header.php";
//page::header();

?>

<div class="card profile">

    <div class="row">

        <div class="col col-w12 m-auto">
            <div class="avatar-xl p-4">
                <img src="/<?= SUBFOLDER ?>src/images/users/<?= $user_id ?>.png" onerror="this.src='/<?= SUBFOLDER ?>src/images/users/default.png';">
            </div>
        </div>

        <div class="col">

            <div class="profile-info p-4 m-auto">

                <div class="profile-name">
                    <?= $user['name'] ?>
                </div>
                <div class="profile-designation"><?= $user['designation'] ?></div>
                <div class="profile-institution"><?= institutions::get($user['institution'])["ins_name"] ?></div>
                <?php if (auth::isadmin()) { ?>

                    <?php if (users::get($user_id)) { ?>
                        <a role="button" class="btn btn-primary my-1 text-light" href="/<?= SUBFOLDER ?>admin/users/profile/update?id=<?= $user_id ?>">Update</a>
                    <?php } ?>
                <?php } ?>

            </div>
        </div>

    </div>
</div>

<div class="card">
    <div class="card-body">

        <div class="list-title">Assigned Roles</div>

        <div class="li-text my-2">

            <?php foreach (userroles::types() as $role) { ?>
                <div class="row text-sm">
                    <?php if (userroles::is_assigned($role["code"], $user_id)) { ?>
                        <div class="col w-2 text-success"><?= UI::icon("success") ?></div>
                        <div class="col"><?= $role['name'] ?></div>
                    <?php } else { ?>
                        <div class="col w-2 text-muted2"><?= UI::icon("lock") ?></div>

                        <div class="col text-muted2"><?= $role['name'] ?></div>

                    <?php  }  ?>

                </div>

            <?php } ?>

        </div>

        <?php if (auth::isadmin()) { ?>

            <?php if (users::get($user_id)) { ?>
                <a role="button" class="btn btn-primary my-1 text-light" href="/<?= SUBFOLDER ?>admin/users/profile/roles?id=<?= $user_id ?>">Update Roles</a>
            <?php } ?>
        <?php } ?>

    </div>
</div>

</script>

<?php page::footer(); ?>