<?php
require "../../../src/config.php";

//redirect already logged in users
if (auth::user()) {
    router::redirect("profile");
}


$username = $password = "";
$warning = false;

if ($_SERVER['REQUEST_METHOD'] == 'POST') {

    $login = auth::login($_POST['username'], $_POST['password']);
    if ($login['success']) {

        //create_log(10, null, $_SERVER['HTTP_USER_AGENT'] . ", " . $_SERVER['REMOTE_ADDR']);
        if (auth::isadmin()) {
            router::redirect("admin_home");
        } else {
            router::redirect("profile");
        }
    } else {
        //create_log(12, null, $_POST['username'] . " (" . $_SERVER['REMOTE_ADDR'] . ")");
        $username = $_POST['username'];
        $password = $_POST['password'];
        $warning = 'Incorrect username or password';
    }
}

page::set([
    "title" => "Log in",
    "size" => "box-full",
    "sidemenu" => false,
    "appbar" => false
]);

page::header();
?>

<div class="login-container">

    <div class="logincard">
        <div class="row h-100">
            <div class="col logincard-left">
                <div class="m-auto">

                    <div class="text-sm text-strong">
                        Central Province Chief Secretary's Office
                    </div>
                    <div class="text-lg text-strong">
                        Disciplinary action information and Monitoring System
                    </div>

                    <img src="/<?= SUBFOLDER ?>src/images/bg-sm.png" alt="" srcset="">

                    <div class="p-2">
                        <span class="version-label">Version 1.0</span>
                    </div>
                </div>
            </div>
            <div class="col-md-5 logincard-right">

                <div class="avatar-lg p-3 center">
                    <img class="" src="/<?= SUBFOLDER ?>src/images/users/default.png">
                </div>

                <div class="text-strong text-lg pb-3 center">
                    Log in to Continue
                </div>

                <form method="post" class="m-auto">

                    <?= ($warning) ? UI::warning($warning) : "" ?>

                    <div class="form-floating my-3">
                        <input type="text" class="form-control" name="username" id="username" placeholder="Username" value="<?= $username ?>" required>
                        <label for="username">Username</label>
                    </div>
                    <div class="form-floating">
                        <input type="password" class="form-control" name="password" id="password" placeholder="Password" required>
                        <label for="passwords">Password</label>
                    </div>

                    <div id="login-block" class="py-4 center">
                        <button class="btn btn-primary btn-block" type="submit" name="submit">Log in</button>
                    </div>

                    <div class="text-sm text-strong pt-2 center">
                        Information Technology Unit <br>
                        © 2025
                    </div>

                </form>
            </div>
        </div>
    </div>

</div>

<div class="loginpage-container" hidden>
    <div class="card">

        <div class="row">

            <div class="col loginpage-cover">

                <div class=" ">

                    <div class="text-sm text-strong">
                        Central Province Chief Secretary's Office
                    </div>
                    <div class="text-lg text-strong">
                        Managemnet Information System
                    </div>
                    <div class="p-2">
                        <span class="version-label">Version 1.3</span>
                    </div>
                    <img id="loginpage-background" src="<?= SUBFOLDER ?>/src/images/bg-sm.jpg" alt="" srcset="">
                    <div class="text-sm text-strong pt-2 center">
                        Information Technology Unit <br>
                        © 2024
                    </div>
                </div>

            </div>

            <div class="col loginpage-sidepanel">

                <form method="post" class="center m-auto">

                    <div class="avatar-lg p-3">
                        <img class="" src="/<?= SUBFOLDER ?>src/images/users/default.png">
                    </div>

                    <div class="text-strong text-lg pb-3 center">
                        Login to Continue
                    </div>

                    <?= ($warning) ? UI::warning($warning) : "" ?>

                    <div class="form-floating my-3">
                        <input type="text" class="form-control" name="username" id="username" placeholder="Username" value="<?= $username ?>" required>
                        <label for="username">Username</label>
                    </div>
                    <div class="form-floating">
                        <input type="password" class="form-control" name="password" id="password" placeholder="Password" required>
                        <label for="passwords">Password</label>
                    </div>

                    <div id="login-block" class="py-2 pt-3 center">
                        <button class="btn btn-primary btn-block" type="submit" name="submit">Login</button>
                    </div>

                </form>

            </div>
        </div>

    </div>
</div>
<script>
    $('form').submit(function() {
        $("#login-block").html(UI_loading);
    });
</script>

<?php page::footer(); ?>