<?php

require "../../../src/config.php";

if (isset($_GET['id'])) {
    $user_id = $_GET['id'];
    $user = users::get($_GET["id"]);
    if (!$user) {
        error("Invalid User Profile");
    }
} else if (auth::user()) {
    $user_id = auth::user();
    $user = users::get($user_id);
} else {
    router::redirect("login");
}

page::set([
    "title" => $user["shortname"] . " - Profile",
    "page_id" => "profile_mail",
    "nav-parent" => "user_profile_" . $user_id,
    "size" => "box-xl",
    "scripts" => ["chartjs"],
    "toolbar" => "../"
]);

require FILE_ROOT . "src/layouts/admin/header.php";
//page::header();

?>

<div class="card">
    <div class="card-title">
        <?= UI::icon("summary") ?> &nbsp;ලිපි ප්‍රගතිය
    </div>
    <div class="card-body">

        <div class="datalist my-4">
            <div class="listitem">
                <div class="row listitem-content">

                    <div class="col-w4 li-icon">
                        <?= UI::icon("active") ?>
                    </div>

                    <div class="col-md-6 pe-2">
                        <div class="text-strong text-md">Update Progress</div>
                        <div class="text-muted text-xs">වර්තමාන තත්වය යාවත්කාලීන කර ඇති ලිපි</div>
                    </div>
                    <div class="col col-w4 right">
                        <span class="text-md text-strong"><?= userstats::updated_letters($user_id) . "/" . userstats::letters($user_id) ?></span>
                    </div>
                    <div class="col progress">
                        <div class="progress-bar progress-bg-<?= round(userstats::updated_letters($user_id) / userstats::letters($user_id), 1) * 10 ?>" role="progressbar" style="width: 0%" data-value="<?= round(userstats::updated_letters($user_id) / userstats::letters($user_id), 2) * 100  ?>" aria-valuemin="0" aria-valuemax="100"></div>
                    </div>

                    <div class="col col-w6 right m-auto">
                        <div class="text-strong text-xl"><?= round(userstats::updated_letters($user_id) / userstats::letters($user_id), 2) * 100 ?> <span class="text-xs">%</span></div>
                    </div>
                </div>
            </div>
            <div class="listitem">
                <div class="row listitem-content">

                    <div class="col-w4 li-icon">
                        <?= UI::icon("active") ?>
                    </div>

                    <div class="col-md-6 pe-2">
                        <div class="text-strong text-md">Work Progress</div>
                        <div class="text-muted text-xs">ක්‍රියාකල යුතු ලිපිවල වැඩ අවසන් කිරීමේ ප්‍රගතිය</div>
                    </div>
                    <div class="col col-w4 right">
                        <span class="text-md text-strong"><?= userstats::completed_letters($user_id) . "/" . userstats::letters($user_id) ?></span>
                    </div>
                    <div class="col progress">
                        <div class="progress-bar progress-bg-<?= round(userstats::completed_letters($user_id) / userstats::letters($user_id), 1) * 10 ?>" role="progressbar" style="width: 0%" data-value="<?= round(userstats::completed_letters($user_id) / userstats::letters($user_id), 2) * 100  ?>" aria-valuemin="0" aria-valuemax="100"></div>
                    </div>

                    <div class="col col-w6 right m-auto">
                        <div class="text-strong text-xl"><?= round(userstats::completed_letters($user_id) / userstats::letters($user_id), 2) * 100 ?> <span class="text-xs">%</span></div>
                    </div>
                </div>
            </div>
            <div class="listitem">
                <div class="row listitem-content">

                    <div class="col-w4 li-icon text-warning">
                        <?= UI::icon("file") ?>
                    </div>

                    <div class="col-md-6 pe-2">
                        <div class="text-strong text-md">Filing Progress</div>
                        <div class="text-muted text-xs">ලිපි ගොනුවලට එක් කිරීමේ ප්‍රගතිය. </div>
                    </div>
                    <div class="col col-w4 right">
                        <span class="text-md text-strong"><?= userstats::filed_letters($user_id) . "/" . userstats::letters($user_id) ?></span>
                    </div>
                    <div class="col progress">
                        <div class="progress-bar progress-bg-<?= round(userstats::filed_letters($user_id) / userstats::letters($user_id), 1) * 10 ?>" role="progressbar" style="width: 0%" data-value="<?= round(userstats::filed_letters($user_id) / userstats::letters($user_id), 2) * 100  ?>" aria-valuemin="0" aria-valuemax="100"></div>
                    </div>

                    <div class="col col-w6 right m-auto">
                        <span class="text-xl text-strong"><?= round(userstats::filed_letters($user_id) / userstats::letters($user_id), 2) * 100 ?> <span class="text-xs">%</span></span>
                    </div>
                </div>
            </div>



        </div>

    </div>
</div>
<div class="card">
    <div class="row">

        <div class="col col-w12 m-auto">
            <div class="statcard">
                <div class="title">ලැබුණු ලිපි</div>
                <div class="number"><?= userstats::letters($user_id) ?></div>

            </div>
        </div>
        <div class="col p-3 m-auto">

            <div class="datalist my-4">
                <?php foreach (userstats::letters_by_state($user_id) as $value) { ?>
                    <div class="listitem">
                        <div class="row listitem-content">

                            <div class="col-md-6 pe-2">
                                <span class="text-strong progress-text-<?= $value["id"] ?>">
                                    <?= UI::icon("progress-state-" . $value["id"]) . " " . $value["name"] ?>
                                </span>
                            </div>
                            <div class="col col-w4 right">
                                <span class="text-md text-strong"><?= $value["count"] ?></span>
                            </div>
                            <div class="col progress">
                                <div class="progress-bar" role="progressbar" style="width: <?= round($value["count"] / userstats::letters($user_id), 2) * 100 ?>%" aria-valuenow="<?= round($value["count"] / userstats::letters($user_id), 2) * 100 ?>" aria-valuemin="0" aria-valuemax="100"></div>
                            </div>

                            <div class="col col-w4 right">
                                <span class="text-muted text-strong"><?= round($value["count"] / userstats::letters($user_id), 2) * 100 ?> %</span>
                            </div>
                        </div>
                    </div>
                <?php } ?>
            </div>

        </div>
    </div>
</div>
<script src="https://cdn.jsdelivr.net/npm/chartjs-plugin-datalabels"></script>
<script>
    /*
    Chart.defaults.font.family = 'Yaldevi';
    Chart.defaults.font.size = 16;

    var data_labels = [];
    var data_values = [];
    var data = [];
    var alldata = [];
    var month_names = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
    var currentyear = new Date().getFullYear();

    $.getJSON(API + "mail/user/receivedbymonth.php", {
        userid: <?= $user_id ?>
    }, function(response) {
        console.log(response["data"]);
        response["data"].forEach(element => {
            data[element.y + "_" + element.m] = element;
        });

        console.log(data);

        for (let year = response.data[0].y; year < currentyear + 1; year++) {

            for (let month = 1; month < 13; month++) {
                data_labels.push(year + " " + month_names[month - 1]);
                if (data[year + "_" + month]) {
                    data_values.push(data[year + "_" + month].c);
                } else {
                    data_values.push(0);
                }
            }

        }

        renderchart();
    });
    console.log(data_labels);

    function renderchart() {
        const ctx = document.getElementById('myChart');
        Chart.register(ChartDataLabels);
        new Chart(ctx, {
            type: 'bar',
            data: {
                labels: data_labels,
                datasets: [{
                    label: 'Letters',
                    data: data_values,
                    backgroundColor: [
                        'rgba(21, 143, 143,0.9)'
                    ],
                    borderRadius: 1
                }]
            },
            options: {
                scales: {
                    y: {
                        beginAtZero: true,
                        max: 120,
                    }
                },
                plugins: {
                    datalabels: {
                        display: false,
                        // Position of the labels 
                        // (start, end, center, etc.)
                        anchor: 'end',
                        // Alignment of the labels 
                        // (start, end, center, etc.)
                        align: 'end',
                        font: {
                            weight: 'bold',
                            size: 12
                        },
                        formatter: function(value, context) {
                            // Display the actual data value
                            return value;
                        }
                    },
                    legend: {
                        display: false
                    },
                    tooltip: {
                        enabled: true
                    }
                }
            }
        });
    }
*/
    function changecategory(category) {

        $(".pill").removeClass("active");
        $("#pill_" + category).addClass("active");
        //show();
    }

    function animate_progress() {
        $('.progress-bar').each(function(index) {
            var element = $(this);
            setTimeout(function() {
                element.css({
                    'width': element.data("value") + "%",
                    "transition": "width 1s",
                    "transition-timing-function": "ease"
                });
            });
        });
    }

    animate_progress();
</script>

<?php page::footer(); ?>